/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.connection.InitialHandler;
import net.skinsrestorer.api.bungeecord.events.SkinApplyBungeeEvent;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.exception.ReflectionException;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shared.interfaces.ISRPlugin;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.utils.log.SRLogger;

public abstract class SkinApplierBungeeShared {
    private final ISRPlugin plugin;
    private final SRLogger log;

    public void applySkin(String nick, InitialHandler handler) throws SkinRequestException {
        try {
            this.applyEvent(null, this.plugin.getSkinStorage().getSkinForPlayer(nick), handler);
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
    }

    protected void applySkin(ProxiedPlayer player, IProperty property) {
        try {
            this.applyEvent(player, property, (InitialHandler)player.getPendingConnection());
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
    }

    private void applyEvent(@Nullable ProxiedPlayer player, IProperty property, InitialHandler handler) throws ReflectionException {
        SkinApplyBungeeEvent event = new SkinApplyBungeeEvent(player, property);
        ProxyServer.getInstance().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.applyWithProperty(player, handler, event.getProperty());
    }

    private void applyWithProperty(@Nullable ProxiedPlayer player, InitialHandler handler, IProperty textures) throws ReflectionException {
        this.applyToHandler(handler, textures);
        if (player == null) {
            return;
        }
        this.sendUpdateRequest(player, Config.FORWARD_TEXTURES ? textures : null);
    }

    protected abstract void applyToHandler(InitialHandler var1, IProperty var2) throws ReflectionException;

    public abstract List<IProperty> getProperties(ProxiedPlayer var1);

    private void sendUpdateRequest(@NotNull ProxiedPlayer player, IProperty textures) {
        if (player.getServer() == null) {
            return;
        }
        this.log.debug("Sending skin update request for " + player.getName());
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("SkinUpdate");
            if (textures != null) {
                out.writeUTF(textures.getName());
                out.writeUTF(textures.getValue());
                out.writeUTF(textures.getSignature());
            }
            player.getServer().sendData("sr:skinchange", b.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SkinApplierBungeeShared(ISRPlugin plugin, SRLogger log) {
        this.plugin = plugin;
        this.log = log;
    }
}

